<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="UNICOM">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
        integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous">
    </script>
    {{--    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script> --}}
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
    <meta property="og:title" content="unicom">
    <link rel="icon" type="image/x-icon" href="/favicons/img-favicon.png" />


    <title>@yield('title', 'Default Title')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"
        integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/css/ar.css" />
    <link rel="stylesheet" href="/css/main.css?version=2" />


    @yield('head')
</head>

<body>

    <div class="" style=";text-align: end;">
        <div class="general-menu-container">
            <header id="header" class="header header-transparent">

                <nav style="min-height: 80px" class="navbar navbar-inverse navbar-expand-lg">
                    <div class="container-fluid" style="padding: 0 0 0 20px">

                        <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarSupportedContent" style="padding: 0 30px"
                            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <a class="d-lg-none navbar-brand flex-grow" href="#" style="padding: 0 30px;float: left">
                            <img height="40px" class="logo-un"
                                style="float: left;margin-bottom: 10px;max-width: 179px;"
                                src="{{ asset('/images/full-logo-red.png') }}" alt="Logo" />
                        </a>

                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav" id="navbarMenu"
                                style=" padding: 15px;
    list-style-type: none;justify-content: start;width: 100%">
                                <li class="nav-li">
                                    <a class="{{ request()->is('/') ? 'activeUrl' : '' }}  nav-btn nav-btn-main"
                                        href="/">الرئيسية</a>
                                </li>

                                <li class="nav-li">
                                    <a class="{{ request()->is('/') ? 'activeUrl' : '' }}  nav-btn nav-btn-main"
                                        href="/">من نحن</a>
                                </li>

                                <li class="nav-li">
                                    <a class="{{ request()->is('/') ? 'activeUrl' : '' }}  nav-btn nav-btn-main"
                                        href="/">الحلول</a>
                                </li>
                                <li class="nav-li">
                                    <a class="{{ request()->is('/') ? 'activeUrl' : '' }}  nav-btn nav-btn-main"
                                        href="/contact_us">تواصل معنا</a>
                                </li>


                            </ul>
                        </div>


                        <a class="logo_header_show navbar-brand flex-grow" href="#"
                            style="padding: 0 0 0 15px;float: left">
                            <img height="40px" class="logo-un"
                                style="float: left;margin-bottom: 10px;max-width: 190px;"
                                src="{{ asset('/images/full-logo-red.png') }}" alt="Logo" />
                        </a>
                    </div>
                </nav>

            </header>
        </div>
        <main class="main-container">

            <div>

                @yield('content')
            </div>
        </main>
        <footer class="footer">
            <div class="footer-content-wrapper">
                <br />
                <div class="container-fluid ">
                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-12 mb-3">
                            <div class="footer-section from_down">


                                <div style="width: 100%">

                                    <ul
                                        style="display: grid;grid-template-columns: 1fr;gap: 20px; list-style: none;padding: 0;margin: 0;">
                                        <li>
                                            <div class="d-flex justify-content-center">
                                                <h2>تواصل مع فريقنا</h2>
                                            </div>

                                        </li>
                                        <li>
                                            <div class="d-flex justify-content-center">
                                                <p style="text-align: center">فريق يونيكوم تليكوم هنا لمساعدتكم! دعونا
                                                    نتواصل لمعرفة كيف يمكننا دعم وكالتكم.</p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex justify-content-center">
                                                <a href="/contact_us">
                                                    <button class="contact-btn"
                                                        style="position: relative;min-width: 130px">
                                                        <div class="contact-btn-icon"
                                                            style="position: absolute;right: 0;margin-right: -10px">
                                                            <i class="bi bi-telephone-fill"></i>
                                                        </div>

                                                        <span style="padding-right: 25px;font-weight: bold">تواصل معنا
                                                        </span>
                                                    </button>
                                                </a>
                                            </div>

                                        </li>

                                    </ul>
                                </div>

                            </div>
                        </div>

                        <div class="col-lg-3 col-md-3 col-12 mb-3">
                            <div class="d-flex flex-column align-items-center footer-section from_down">
                                <div class="d-flex justify-content-center align-items-center">
                                    <div>
                                        <div class="unicom_footer_title">
                                            <h3><b style="font-size: 20px">الحلول</b></h3>
                                        </div>
                                        <br />
                                        <div style="width: 100%">

                                            <ul
                                                style="display: grid;grid-template-columns: 1fr 1fr;gap: 20px; list-style: none; padding: 0;margin: 0;">
                                                <li><a href="/about-us" class="footer_link">الحرجة للمهام</a></li>
                                                <li><a href="/unicom" class="footer_link">الاتصالات</a></li>
                                                <li><a href="/unicom-rowad" class="footer_link">الأمن السيبراني</a>
                                                </li>
                                                <li><a href="/jobs" class="footer_link">مراكز البيانات</a></li>
                                                <li><a href="#" class="footer_link">حلول الشبكات وتقنية
                                                        المعلومات </a></li>
                                                <li><a href="http://proserveme.com/" target="_blank"
                                                        class="footer_link">
                                                        المدن الذكية</a>
                                                </li>
                                                <li><a href="#" class="footer_link"> تقنية التعليم</a></li>
                                                <li><a href="/privacy" class="footer_link">التحول الرقمي</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="col-lg-3 col-md-3 col-12 mb-3">
                            <div class="d-flex flex-column align-items-center footer-section from_down contact-info">
                                <div class="d-flex justify-content-center align-items-center">
                                    <div>
                                        <div class="unicom_footer_title">
                                            <h3><b style="font-size: 20px">معلومات الاتصال</b></h3>
                                        </div>
                                        <br />
                                        <div style="width: 100%">

                                            <ul
                                                style="display: grid;grid-template-columns: 1fr;gap: 20px; list-style: none;padding: 0;margin: 0;">
                                                <li>
                                                    <div class="d-flex justify-content-start">
                                                        <div>
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="12"
                                                                height="17" viewBox="0 0 12 17">
                                                                <path id="Icon_material-location-on"
                                                                    data-name="Icon material-location-on"
                                                                    d="M13.5,3a5.971,5.971,0,0,0-6,5.95c0,4.462,6,11.05,6,11.05s6-6.587,6-11.05A5.971,5.971,0,0,0,13.5,3Zm0,8.075A2.125,2.125,0,1,1,15.643,8.95,2.135,2.135,0,0,1,13.5,11.075Z"
                                                                    transform="translate(-7.5 -3)" fill="#fafafa" />
                                                            </svg>
                                                        </div>
                                                        <div><a href="/unicom-saudi" style="color:#acb0b2;"
                                                                class="footer_link">الرياض،
                                                                المملكة
                                                                العربية
                                                                السعودية</a></div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex justify-content-start">

                                                        <div style="margin-top: 7px">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="15.667"
                                                                height="16" viewBox="0 0 15.667 16">
                                                                <path id="Icon_awesome-phone-alt"
                                                                    data-name="Icon awesome-phone-alt"
                                                                    d="M15.22,11.307l-3.427-1.5a.724.724,0,0,0-.857.216L9.418,11.916A11.466,11.466,0,0,1,4,6.379l1.854-1.55a.759.759,0,0,0,.211-.875L4.593.454A.735.735,0,0,0,3.751.019L.569.769A.747.747,0,0,0,0,1.5,14.35,14.35,0,0,0,14.2,16a.738.738,0,0,0,.716-.581l.734-3.25a.763.763,0,0,0-.429-.863Z"
                                                                    transform="translate(0 0)" fill="#fafafa" />
                                                            </svg>
                                                        </div>
                                                        <div>
                                                            <a href="#"
                                                                style="color: #acb0b2; unicode-bidi: embed; direction: ltr; text-align: right; display: inline-block;"
                                                                class="footer_link">+966 1 456 5699</a>
                                                        </div>
                                                    </div>

                                                </li>
                                                <li>
                                                    <div class="d-flex justify-content-start">
                                                        <div>
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="15.667"
                                                                height="10.533" viewBox="0 0 15.667 12.533">
                                                                <path id="Icon_material-email"
                                                                    data-name="Icon material-email"
                                                                    d="M17.1,6H4.567A1.565,1.565,0,0,0,3.008,7.567L3,16.967a1.571,1.571,0,0,0,1.567,1.567H17.1a1.571,1.571,0,0,0,1.567-1.567v-9.4A1.571,1.571,0,0,0,17.1,6Zm0,3.133L10.833,13.05,4.567,9.133V7.567l6.267,3.917L17.1,7.567Z"
                                                                    transform="translate(-3 -6)" fill="#fafafa" />
                                                            </svg>
                                                        </div>
                                                        <div>
                                                            <a href="mailto:info@unicomg.com" style="color: #acb0b2"
                                                                class="footer_link">info@unicom-telecom.com</a>

                                                        </div>
                                                    </div>
                                                </li>

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-12 mb-3">
                            <div class="footer-section from_down" style="margin-top: -20px">
                                <div>
                                    <a href="#"><img
                                            style="width: 230px;padding: 10px; display: block;margin: auto"
                                            src="{{ asset('/images/logo.png') }}" alt="Logo" /></a>
                                </div>
                                <br />
                                <div class="d-flex justify-content-center align-item-center">
                                    <div>
                                        <p style="font-size: 14px;max-width: 250px">اشترك في نشرتنا الإخبارية للحصول
                                            على آخر
                                            التحديثات والأخبار</p>
                                        <form method="post">
                                            @csrf
                                            <table>
                                                <tr>
                                                    <td>
                                                        <div style="height: 100%"><input type="text"
                                                                class="email-placehoder"
                                                                style="border: none;font-size: 16px;color: #0B2F58;height: 48px;margin-top: 7px;border-radius: 4px;caret-color: #0B2F58;max-height: 100px;/* background-color: #fff; */width: 200px;"
                                                                name="email"
                                                                placeholder="اكتب بريدك الإلكتروني هنا">
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn2 "
                                                            style="width: 100%;height: 48px;margin:24px 0 0 5px;padding: 10px;">
                                                            اشتراك
                                                        </button>
                                                    </td>
                                                </tr>


                                            </table>
                                        </form>
                                    </div>
                                </div>

                                <br />
                                <div>
                                    <a href="#" style="text-align: center; display: block;margin: auto">
                                        <img src="/svg/logo2030.svg" />
                                    </a>
                                </div>

                            </div>
                        </div>


                    </div>
                </div>
            </div>

        </footer>
        <div style="background-color: #40465C;width: 100%;height: 50px" class="d-flex justify-content-center">
            <div class="copyright" style="float: right;padding: 16px;color: white">© Copyright 2025 Unicom Telecom
            </div>
        </div>

        <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>


        <style>
            .contact-btn {
                background-color: #002b54;
                /* Dark blue background */
                color: white;
                border: none;
                border-radius: 50px;
                padding: 10px 20px;
                display: inline-flex;
                align-items: center;
            }

            .contact-btn:hover {
                background-color: #003a70;
                /* Slightly lighter blue on hover */
                color: white;
            }

            .contact-btn-icon {
                background-color: white;
                color: #002b54;
                border-radius: 50%;
                width: 40px;
                height: 40px;
                display: flex;
                justify-content: center;
                align-items: center;
                margin-right: 10px;
            }
        </style>
        @yield('foot')
</body>

</html>
