<?php

use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');


Route::prefix('/solutions')->name('solutions.')
    ->group(function () {

        Route::get('/mission-critical', [App\Http\Controllers\SolutionsController::class, 'mission_critical'])->name('mission_critical');
        Route::get('/cyber-security', [App\Http\Controllers\SolutionsController::class, 'cyber_security'])->name('cyber_security');
        Route::get('/data-centers', [App\Http\Controllers\SolutionsController::class, 'data_centers'])->name('data_centers');
        Route::get('/digital-transformation', [App\Http\Controllers\SolutionsController::class, 'digital_transformation'])->name('digital_transformation');
        Route::get('/education-technology', [App\Http\Controllers\SolutionsController::class, 'education_technology'])->name('education_technology');
        Route::get('/networks', [App\Http\Controllers\SolutionsController::class, 'network'])->name('network');
        Route::get('/smart-cities', [App\Http\Controllers\SolutionsController::class, 'smart_city'])->name('smart_city');
        Route::get('/telecom', [App\Http\Controllers\SolutionsController::class, 'telecom'])->name('telecom');






    });

Route::get('/contact_us', [App\Http\Controllers\HomeController::class, 'contact_us'])->name('contact_us');

