<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class NewsCardComponent extends Component
{
    /**
     * Create a new component instance.
     */

    public $words = [];
    public $shortText = '';

    public function __construct(public $img='',public $title='',public $desc='',public $date='',public $link='')
    {
        $this->words = explode(' ', $desc);
        $this->shortText = implode(' ', array_slice($this->words, 0, 20));
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.news-card-component');
    }
}
