@extends('layouts.home_layout')

@section('title', 'UNICOM - Home')
<style>

    .country-overlay-img{
        position: absolute;
        width: 100%;
        height: 100%;
        object-fit: cover;
        margin: 0px;
        background-image: url({{ asset('images/country_bg.png') }});
        background-size: contain;
        background-repeat: no-repeat;
    }
    .gallery {
        position: relative;
        width: 400px;
        /* تعديل العرض حسب الحاجة */
        height: 400px;
        /* تعديل الارتفاع حسب الحاجة */
        border-radius: 50%;
        overflow: hidden;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .country-card {
        position: absolute;
        width: 250px;
        height: 150px;
        border-radius: 50%;
        overflow: hidden;
        transition: transform 0.3s ease;
        text-decoration: none;
    }

    .country-card img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        margin: 0px;
        margin-right: 0px;
        margin-bottom: 0px;
        margin-left: 0px;
        padding: 0px;
    }


    .country-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(0, 0, 0, 0.7);
        color: white;
        text-align: center;
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .country-card:hover .country-overlay {
        opacity: 1;
    }

    /* تحديد مواقع الصور بشكل دائري */
    .country-card:nth-child(1) {
        transform: rotate(0deg) translate(150px) rotate(0deg);
    }

    .country-card:nth-child(2) {
        transform: rotate(60deg) translate(150px) rotate(-60deg);
    }

    .country-card:nth-child(3) {
        transform: rotate(120deg) translate(150px) rotate(-120deg);
    }

    .country-card:nth-child(4) {
        transform: rotate(180deg) translate(150px) rotate(-180deg);
    }

    .country-card:nth-child(5) {
        transform: rotate(240deg) translate(150px) rotate(-240deg);
    }
</style>
@section('head')


@endsection
@section('content')

    <section class=""
        style="background-image: url(/images/home.png);background-repeat: no-repeat;background-size: cover;min-height: 650px;background-position: center;">
        <!-- <section style="background-image: url('/images/home.png');background-color: #cccccc;height: 500px;background-position: center;background-repeat: no-repeat;background-size: cover;position: relative;"> -->
        <div style="min-height: 75vh;" class="row">
            <div class="" style="text-align: right;margin: 100px 110px;" class="">
                <span class="underline-text-home3-Uncom"></span>
                <p class="underline-text-home-Uncom" style="color: #fff;font-size: 18px;">مرحبا بك في يونيكوم</p>
                <h2 class="" style="color: #fff;font-weight: 700;">نبني معا تكنولوجيا الغد</h2>
            </div>
        </div>
    </section>


    <section id="about-section" style="background: rgba(255,255,255,0.5);margin: 0 35px">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-md-6 order-md-1">
                    <div class="about-image-container waveImage">
                        <img class="from_right  " src="/images/map_blue.png" alt="Innovation and Technology">
                    </div>
                </div>
                <div class="col-md-6 order-md-2">
                    <div id="hero-intro " class="about-content ">
                        <h2 class="mb-4 from_left"
                            style="font-weight: normal;
font-weight: bold;
font-size: 29px;
line-height: 57px;
text-align: right;
color: #373c51;

">
                            نضـيء الطريـــق إلـى غد أفضل بأحدث
                            <span style="color: #002359">تقنيات الابتكــار</span>

                        </h2>
                        <div class="from_left">
                            <p class="mb-4 from_left"
                                style="font-weight: normal;font-size: 17px;line-height: 35px;text-align: right;color: #666874;
">
                                هي شركة رائدة في مجال تكنولوجيا المعلومات تقدم استشارات تكنولوجيا المعلومات ودعم تكنولوجيا
                                المعلومات للأعمال إلى المنظمات من جميع الأحجام
                                ،
                                هدفنا هو تقديم حلول إبداعية لتكنولوجيا المعلومات المتقدمة لمساعدة عملائنا على تحقيق أهداف
                                النمو الخاصة بهم.
                            </p>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section style="position:relative;padding-bottom: 70px;padding-top: -50px">

        <div class="home-background-overlay-s2"></div>
        <div class="home-background-overlay-s2-2"></div>

        <div class="d-flex justify-content-center align-items-center p-4">
            <div style="max-width: 700px">
                <div class="row">

                    <div class=" d-block d-md-none  col-12 col-md-6" style="text-align: center">
                        <img src="/images/home-1-3.png" style="width: 150px;height: 150px" alt="ss" />
                    </div>
                    <div class="col-12 col-md-6" style="text-align: center">

                        <div
                            style="font-weight: bold;font-size: 21px;line-height: 41px;text-align: center;color: var(--my-color-red)">
                            مهمتنا
                        </div>
                        <div
                            style="
font-weight: normal;
font-size: 17px;
line-height: 35px;
text-align: right;
color: #666874;

">
                            اعتمدنا في توسعنا على الخبرات المكتسبة من المشاريع الناجحة التي نفذتها المجموعة في الأسواق
                            الخارجية.</div>
                    </div>
                    <div class="d-none d-md-block col-12 col-md-6" style="text-align: center">
                        <img src="/images/home-1-3.png" style="width: 150px;height: 150px" alt="ss" />
                    </div>
                </div>

            </div>
        </div>

        <div class="d-flex justify-content-center align-items-center p-4">
            <div style="max-width: 700px">
                <div class="row">
                    <div class="col-12 col-md-6" style="text-align: center">
                        <img src="/images/home-1-4.png" style="width: 200px;height: 200px" alt="ss" />
                    </div>
                    <div class="col-12 col-md-6">
                        <div
                            style="font-weight: bold;font-size: 21px;line-height: 41px;text-align: center;color: var(--my-color-red)">
                            رؤيـتـنـا
                        </div>
                        <div
                            style="
font-weight: normal;
font-size: 17px;
line-height: 35px;
text-align: right;
color: #666874;
">
                            بالرغم من توقع تحديات مستقبلية متعددة، فإننا ملتزمون بالمبادئ والرؤية التي تأسست عليها مجموعتنا،
                            وقد أثبتت جهودنا المستمرة ومواكبتنا للتطور فعالية جميع المبادرات، مما أسهم في بناء مجموعة شركات
                            قوية ومتماسكة.</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-center align-items-center p-4" style="margin-bottom: 50px">
            <div style="max-width: 700px">
                <div class="row">


                    <div class="col-12 col-md-6" style="text-align: center">

                        <div class=" d-block d-md-none  col-12 col-md-6" style="text-align: center">
                            <img src="/images/home-1-5.png" style="width: 200px;height: 200px" alt="ss" />
                        </div>
                        <div
                            style="font-weight: bold;font-size: 21px;line-height: 41px;text-align: center;color: var(--my-color-red)">
                            هدفنا
                        </div>
                        <div
                            style="font-family: Cairo;
font-weight: normal;
font-size: 17px;
line-height: 35px;
text-align: right;
color: #666874;

">
                            ســنواصــل التوســع خــارج حـدود منطقـة الـشرق الأوسـط مـن خـلال الاعــتمـــاد عـــلى
                            الـــخــبـرات الـــمكـــــتســــــبـــــة مـــــــــن الــمشرــــوعــات
                            الـــــــــنــاجــــحـــة لــلنــمــو داخـــــل أســـــواق جــــديــــــدة فــــي
                            مــــختلـــف أنحـــاء العـــالم.
                        </div>
                    </div>
                    <div class="d-none d-md-block col-12 col-md-6" style="text-align: center">

                        <img src="/images/home-1-5.png" style="width: 200px;height: 200px" alt="ss" />
                    </div>
                </div>

            </div>
        </div>


    </section>


    <br />
    <br />
    <br />
    <br />
    <br />
    <section style="">
        <div>
            <div class="row" style="position: relative;margin: 0 50px">
                <div class="home-background-overlay-s3"></div>
                <div class="col-12 col-md-4" style="text-align: right;padding: 0">
                    <img src="/images/target2.jpg" alt="Img Unicom Solutions"
                        style="width: 100%;object-fit: cover;height: 100%">
                </div>
                <div class="col-12 col-md-8" style="position: relative;;margin-top: 12px;">

                    <div style="max-width: 600px;margin-right: 50px">

                        <h1 class=""
                            style="font-weight: bold;font-size: 25px;color: #fff;line-height: 49px;text-align: right;">
                            نمتلك أفضل الحلول</h1>
                        <h2 class=""
                            style="color: #fff;font-weight: bold;font-size: 20px;line-height: 34px;text-align: right;">
                            في مجالات تكنولوجيا المعلومات والاقتصاد الرقمي وحلول الحوسبة السحابية لتلبية احتياجات
                            العملاء</h2>
                    </div>

                    <div style="margin-bottom: 20px;">
                        <span
                            style=";border: 1px solid #fff;border-radius: 4px;background: none;margin-left: 100px;cursor: pointer">
                            <a href="/unicom-solutions" target="_blank"
                                style="cursor: pointer;text-decoration: none;color: #fff;font-size: 18px;font-weight: 600;padding: 20px;">أعرف
                                أكثر</a></span>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <br />
    <br />
    <br />
    <br />

    <div style="text-align: center;font-size: 25px;color: #1d507e;">فـــــــــروعنا</div>
    <br>

    <section class="container" style="background-image: linear-gradient(#f4f3f9, #fff, #fff, #f4f3f9);max-width: 1550px;">
        <div class="row"
            style="display: flex;justify-content: space-between;align-items: center;max-width: 1200px;margin: 0 auto;padding: 0px;">
            <div class="col-6 d-flex justify-content-center ">
                <img src="/images/home_last_section.png" alt=""
                    style="margin: auto;margin-bottom: -10px;max-width: 280px;">
            </div>

            <div class="col-6" style="padding: 25px;position: relative">

                <div class="country-overlay-img"></div>
                <div class="gallery" id="countryGallery">

                </div>
            </div>

            <div style="text-align: right;margin-top: -250px;margin-right: 398px;">
                <button
                    style="    margin-top: 200px;;padding: 7px 24px;border: 1px solid #B73238;border-radius: 4px;background: none;">
                    <a target="_blank" href="/unicom"
                        style="text-decoration: none;color: #B73238;font-size: 18px;font-weight: 600;">أعرف
                        أكثر</a></button>
            </div>
        </div>
        <br />
        <br />
        <br />
    </section>




    <br />
    <br />
    <br />

@endsection

@section('foot')

    <script>
        const countries = [{
                name: "Unicom Gulf",
                image: "images/unicom-branches/الخليج.png",
                link: "/counties/gulf"
            },

            {
                name: "Unicom China",
                image: "images/unicom-branches/الصين.png",
                link: "/counties/china"
            },
            {
                name: "Unicom yemen",
                image: "images/unicom-branches/اليمن.png",
                link: "/counties/yemen"
            },
            {
                name: "Unicom sudan",
                image: "images/unicom-branches/السودان.png",
                link: "/counties/sudan"
            },

            {
                name: "Unicom Egypt",
                image: "images/unicom-branches/مصر.png",
                link: "/counties/egypt"
            },
            {
                name: "Unicom Saudi",
                image: "images/unicom-branches/السعودية.png",
                link: "/counties/saudi-arabia"
            },
        ];

        const gallery = document.getElementById('countryGallery');

        countries.forEach((country, index) => {
            const card = document.createElement('a');
            card.href = country.link;
            card.className = 'country-card';
            card.target = '_blank'; // لفتح الرابط في نافذة جديدة
            card.innerHTML = `
            <img src="${country.image}" alt="${country.name}">

        `;
            gallery.appendChild(card);
        });
    </script>

    <script>
        function gotoAboutUs() {
            window.location.href = "{{ route('bout_us') }}";
        }
    </script>
@endsection
