@extends('layouts.home_layout')
@section('title', 'تفاصيل الوظيفة')
@section('head')

    <style>
        .drop-zone {
            height: 200px;
            padding: 25px;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            border: 2px dashed var(--my-color-dark-grey);
            border-radius: 10px;
            background-color: #f8f9fa;
            position: relative;
            cursor: pointer;
        }

        .drop-zone--over {
            border-style: solid;
            background-color: rgba(0, 123, 255, 0.1);
        }

        .drop-zone__input {
            display: none;
        }

        .drop-zone__thumb {
            width: 100%;
            height: 100%;
            border-radius: 10px;
            overflow: hidden;
            background-color: #cccccc;
            background-size: cover;
            position: relative;
        }

        .drop-zone__thumb::after {
            content: attr(data-label);
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 5px 0;
            color: #ffffff;
            background: rgba(0, 0, 0, 0.75);
            font-size: 14px;
            text-align: center;
        }

        .upload-icon {
            width: 50px;
            height: 50px;
            background-color: var(--my-color-dark-grey);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
        }

        .upload-icon svg {
            width: 30px;
            height: 30px;
            fill: white;
        }
    </style>
@endsection

@section('content')

    <section style="background-color: #fafafa85;">
        <div style="min-height:50vh;    margin-top: -36px; " class="d-flex justify-content-center align-items-center">
            <div
                style="text-align: left;color: var(--my-color-dark-grey);font-size: 35px;font-weight: bold;margin-right: 0">
                <span style="margin-left: -9px">تفاصيل </span>
                <div
                    style="text-align: center;display: inline-block;background-color: #b73238;padding: 0;margin: 0;width: 166px;max-height: 58px;color: #fff;">
                    الوظيفة
                </div>


                <div class=""
                     style="font-size: 16px;font-weight:normal;color: var(--my-color-grey-text);text-align: center;margin-top: -33px;">
                <span>
                    الرئيسية /
                </span>
                    <span class="red-underline">
تفاصيل الوضيفة
                </span>
                </div>
            </div>
        </div>
    </section>

    <section style="padding: 10px 30px;background-color: var(--my-color-grey2-bg)">

        <br/>
        <div style="text-align: right">

            <span><i class="bi bi-briefcase"></i></span>
            <span>مطور برمجيات </span>
            <br/>
            <br/>
            <br/>

            <div class="row">

                <div class="col-12 col-md-4 col-lg-3">

                    <div style="background-color: #FFFFFF;border-radius: 6px" class="p-4">
                        <img src="/images/logo/ksa.png" style="width: 200px;height: 100px;" alt=""/>


                        <table>
                            <tr>
                                <td>
                                    <i class="bi bi-building"></i>
                                </td>
                                <td style="color: var(--my-color-grey-text);font-weight: normal;font-size: 16px;line-height: 47px;text-align: right;">
                                    السعودية - الرياض
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="bi bi-clock-history"></i>
                                </td>
                                <td style="color: var(--my-color-grey-text);font-weight: normal;font-size: 16px;line-height: 47px;text-align: right;">
                                    دوام كامل
                                </td>
                            </tr>

                            <tr>
                                <td><i class="bi bi-calendar3"></i></td>
                                <td style="color: var(--my-color-grey-text);font-weight: normal;font-size: 16px;line-height: 47px;text-align: right;">
                                    ينتهي بتاريخ : 22-02-2022 م
                                </td>
                            </tr>
                        </table>
                        <div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-md-8">

                    <div style="background-color: #FFFFFF;border-radius: 6px" class="p-4">

                        <div
                            style="color: var(--my-color-grey-text);font-weight: 600;font-size: 18px;line-height: 72px;text-align: right;">
                            تفاصيل الوظيفة
                        </div>
                        <hr>
                        <br/>
                        <div
                            style="color: var(--my-color-grey-text);font-weight: 300;font-size: 16px;line-height: 33px;text-align: right;">
                            هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص
                            للتجربة فقط هدا
                            هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص
                            للتجربة فقط هدا
                            هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص
                            للتجربة فقط هدا
                            هدا النص للتجربة فقط
                        </div>

                    </div>

                    <br/>

                    <div style="background-color: #FFFFFF;border-radius: 6px" class="p-4">

                        <div
                            style="color: var(--my-color-grey-text);font-weight: 600;font-size: 18px;line-height: 72px;text-align: right;">
                            تفاصيل الوظيفة
                        </div>
                        <hr>
                        <br/>
                        <div
                            style="color: var(--my-color-grey-text);font-weight: 300;font-size: 16px;line-height: 33px;text-align: right;">
                            هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص
                            للتجربة فقط هدا
                            هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص
                            للتجربة فقط هدا
                            هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص للتجربة فقط هدا النص
                            للتجربة فقط هدا
                            هدا النص للتجربة فقط
                        </div>

                    </div>

                    <br/>

                    <div
                        style="background-color: #FFFFFF;border-radius: 6px" class="p-4"
                    >

                        <form action="#" method="post">


                            <div class="row">

                                <div class="col-6">
                                    <div class="mb-3">
                                        <label class="form-label">اسمك الكامل</label>
                                        <input type="text" class="form-control" id="exampleFormControlInput1"
                                               placeholder="على سبيل المثال احمد محمد علي">
                                    </div>
                                </div>
                                <div class="col-6">

                                    <div class="mb-3">
                                        <label class="form-label">البريد الالكتروني</label>
                                        <input type="text" class="form-control" id="exampleFormControlInput1"
                                               placeholder="name@example.com">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label">رابط موقعك او ملفك الشخصي</label>
                                        <input type="text" class="form-control" id="exampleFormControlInput1">
                                    </div>
                                </div>
                                <div class="col-12">

                                    <label class="form-label">السيرة الذاتية</label>
                                    <div class="container">
                                        <div class="row justify-content-center">
                                            <div class="col-12">
                                                <div class="drop-zone">
                                                    <div class="drop-zone__prompt">
                                                        <div class="upload-icon mx-auto">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                                <path
                                                                    d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM14 13v4h-4v-4H7l5-5 5 5h-3z"/>
                                                            </svg>
                                                        </div>
                                                        <div>
                                                            <strong>اضغط هنا لرفع الملف</strong> او اسقطه هنا <br>
                                                            <small class="text-muted">Supports: JPG, PNG, PDF (max
                                                                5MB)</small>
                                                        </div>
                                                    </div>
                                                    <input type="file" name="myFile" class="drop-zone__input">
                                                </div>

                                                <div class="mt-3">
                                                    <div class="progress" style="display: none;">
                                                        <div
                                                            class="progress-bar progress-bar-striped progress-bar-animated"
                                                            role="progressbar" style="width: 0%"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div  class="col-12">
                                    <label class="form-label">خطاب التقديم</label>
                                    <textarea rows="5" class="form-control" >

                                    </textarea>
                                </div>

                            </div>
                            <br />

                            <button class="btn btn2">قدم الان</button>

                        </form>

                    </div>


                </div>
            </div>

        </div>


    </section>

    <br>






    <br/>
    <br/>
    <br/>

@endsection

@section('foot')
    <script>
        document.querySelectorAll(".drop-zone").forEach(dropZone => {
            const input = dropZone.querySelector(".drop-zone__input");
            const prompt = dropZone.querySelector(".drop-zone__prompt");

            dropZone.addEventListener("click", e => {
                input.click();
            });

            input.addEventListener("change", e => {
                if (input.files.length) {
                    updateThumbnail(dropZone, input.files[0]);
                    simulateUpload();
                }
            });

            dropZone.addEventListener("dragover", e => {
                e.preventDefault();
                dropZone.classList.add("drop-zone--over");
            });

            ["dragleave", "dragend"].forEach(type => {
                dropZone.addEventListener(type, e => {
                    dropZone.classList.remove("drop-zone--over");
                });
            });

            dropZone.addEventListener("drop", e => {
                e.preventDefault();

                if (e.dataTransfer.files.length) {
                    input.files = e.dataTransfer.files;
                    updateThumbnail(dropZone, e.dataTransfer.files[0]);
                    simulateUpload();
                }

                dropZone.classList.remove("drop-zone--over");
            });
        });

        function updateThumbnail(dropZone, file) {
            let thumbnailElement = dropZone.querySelector(".drop-zone__thumb");

            if (dropZone.querySelector(".drop-zone__prompt")) {
                dropZone.querySelector(".drop-zone__prompt").remove();
            }

            if (!thumbnailElement) {
                thumbnailElement = document.createElement("div");
                thumbnailElement.classList.add("drop-zone__thumb");
                dropZone.appendChild(thumbnailElement);
            }

            thumbnailElement.dataset.label = file.name;

            if (file.type.startsWith("image/")) {
                const reader = new FileReader();

                reader.readAsDataURL(file);
                reader.onload = () => {
                    thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
                };
            } else {
                thumbnailElement.style.backgroundImage = null;
            }
        }

        function simulateUpload() {
            const progressBar = document.querySelector('.progress');
            const progressBarFill = progressBar.querySelector('.progress-bar');

            progressBar.style.display = 'flex';
            let progress = 0;

            const interval = setInterval(() => {
                progress += 5;
                progressBarFill.style.width = progress + '%';
                progressBarFill.setAttribute('aria-valuenow', progress);

                if (progress >= 100) {
                    clearInterval(interval);
                    setTimeout(() => {
                        progressBar.style.display = 'none';
                        progressBarFill.style.width = '0%';
                    }, 1000);
                }
            }, 100);
        }
    </script>
@endsection


