<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="UNICOM">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
            integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r"
            crossorigin="anonymous"></script>
    {{--    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>--}}
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
            crossorigin="anonymous"></script>
    <meta property="og:title" content="unicom">
    <link rel="icon" type="image/x-icon" href="/favicons/img-favicon.png"/>

    <meta property="og:description"
          content="unicom هي شركة رائدة في مجال تكنولوجيا المعلومات تقدم استشارات تكنولوجيا المعلومات من الدرجة الأولى ودعم تكنولوجيا المعلومات للأعمال إلى المنظمات من جميع الأحجام. هدفنا هو تقديم حلول إبداعية تكنولوجيا المعلومات المتقدمة لمساعدة عملائنا على تحقيق أهداف النمو الخاصة بهم.">
    <meta property="og:image" content="/svg/logo-icon.svg">
    <meta property="og:image:secure_url" content="/svg/logo-icon.svg"/>
    <meta property="og:image:type" content="image/svg+xml"/>
    <meta property="og:image:width" content="430"/>
    <meta property="og:image:height" content="430"/>

    <meta name="twitter:title" content="unicom">
    <meta name="twitter:description"
          content="unicom هي شركة رائدة في مجال تكنولوجيا المعلومات تقدم استشارات تكنولوجيا المعلومات من الدرجة الأولى ودعم تكنولوجيا المعلومات للأعمال إلى المنظمات من جميع الأحجام. هدفنا هو تقديم حلول إبداعية تكنولوجيا المعلومات المتقدمة لمساعدة عملائنا على تحقيق أهداف النمو الخاصة بهم.">
    <meta name="twitter:creator" content="unicom">
    <meta name="twitter:image" content="/svg/logo-icon.svg">
    <meta name="twitter:domain" content="ypcaden.com">
    <title>@yield('title', 'Default Title')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
          integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"
          integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css"
          integrity="sha512-sMXtMNL1zRzolHYKEujM2AqCLUR9F2C4/05cdbxjjLSRvMQIciEPCQZo++nk7go3BtSuK9kfa/s+a4f4i5pLkw=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/css/ar.css"/>
    <link rel="stylesheet" href="/css/main.css?version=2"/>


    @yield('head')
</head>

<body>

<div class="" style=";text-align: end;">
    <section>
        <div class="upper-header" style="">
            <div class=" d-flex justify-content-start" style="margin: 1px 15px">
                <div>
                    <div class="d-flex justify-content-center">
                        <div>
                            <svg style="cursor: pointer" xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                 fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                                <path
                                    d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001q.044.06.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1 1 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0"/>
                            </svg>
                        </div>
                        <a href="#" style="margin-right: 20px"> <img src="{{ asset('/images/Facebook.png') }}"
                                                                     alt="" class="logo-small"/></a>
                        <a href="#"> <img src="{{ asset('/images/Dribbble.png') }}" alt=""
                                          class="logo-small"/></a>
                        <a href="#"> <img src="{{ asset('/images/Instagram.png') }}" alt=""
                                          class="logo-small"/></a>
                        <a href="#"> <img src="{{ asset('/images/Behance.png') }}" alt=""
                                          class="logo-small"/></a>
                    </div>
                </div>

                <div class="flex-grow-1">
                    <div class="d-flex justify-content-end">
{{--                        <div>--}}
{{--                            <a style="text-decoration: none;cursor: pointer;margin: 15px;color: white" href="/news"--}}
{{--                               class="nav-btn ">أخبارنا</a>--}}
{{--                        </div>--}}
                        <div>
                            <a style="text-decoration: none;cursor: pointer;margin: 15px;color: white" href="/jobs"
                               class="nav-btn ">التوظيف</a>
                        </div>
                        <div>
                            <a style="text-decoration: none;cursor: pointer;margin: 15px;color: white"
                               href="/contact-us"
                               class="nav-btn">تواصل معنا</a>
                        </div>

                        <div>
                            <a style="text-decoration: none;cursor: pointer;color: white;margin: 0" href="#"
                               class="nav-btn">English</a>


                        </div>

                    </div>

                </div>
            </div>
        </div>
    </section>
    <div class="general-menu-container">
        <header id="header" class="header header-transparent">

            <nav style="min-height: 80px" class="navbar navbar-inverse navbar-expand-lg">
                <div class="container-fluid" style="padding: 0 0 0 20px">

                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarSupportedContent"
                            style="padding: 0 30px"
                            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <a class="d-lg-none navbar-brand flex-grow" href="#" style="padding: 0 30px;float: left">
                        <img height="40px" class="logo-un"
                             style="float: left;margin-bottom: 10px;max-width: 179px;"
                             src="{{ asset('/images/full-logo-red.png') }}" alt="Logo"/>
                    </a>

                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav" id="navbarMenu" style=" padding: 15px;
    list-style-type: none;justify-content: start;width: 100%">
                            <li class="nav-li">
                                <a class="{{ request()->is('/') ? 'activeUrl' : '' }}  nav-btn nav-btn-main"
                                   href="/">الرئيسية</a>
                            </li>
                            <li class="nav-li"><a
                                    class="{{ request()->is('about-us') ? 'activeUrl' : '' }}  nav-btn nav-btn-main"
                                    href="/about-us">من نحن</a>
                            </li>
                            <li class="nav-li">
                                <a class="{{ request()->is('unicom') ? 'activeUrl' : '' }} {{ Str::startsWith(Route::currentRouteName(), 'country.') ? 'activeUrl' : '' }}  nav-btn nav-btn-main "
                                   href="/unicom">
                                    يونيكوم
                                </a>

                            </li>
                            <li class="nav-li"><a
                                    class="{{ Str::startsWith(Route::currentRouteName(), 'our_work.') ? 'activeUrl' : '' }}  nav-btn nav-btn-main"
                                    href="/our-work">أعمال يونيكوم</a></li>
                            <li class="nav-li"><a href="/unicom-rowad" class="{{ request()->routeIs('unicom_rowad') ? 'activeUrl' : ''}} nav-btn nav-btn-main">رواد يونيكوم</a></li>
                            <li class="nav-li"><a href="/unicom-solutions" class="{{ request()->routeIs('unicom_solutions') ? 'activeUrl' : ''}}  nav-btn nav-btn-main">حلول يونيكوم</a></li>
                            <li class="  nav-li"><a href="/telecom"
                                                    class="{{ request()->is('telecom') ? 'activeUrl' : ''}} nav-btn nav-btn-main">يونيكوم
                                    للاتصالات</a></li>
                            <li class=" nav-li">
                                <a class="{{ request()->is('unicom-companies') ? 'activeUrl' : '' }} nav-btn nav-btn-main"
                                   href="/unicom-companies"
                                >
                                    شركاتنا
                                </a>


                            </li>
                            <li class="nav-li"><a href="/initiatives"
                                                  class="nav-btn nav-btn-main {{ request()->is('initiatives') ? 'activeUrl' : '' }}">مبادرات
                                    يونيكوم</a></li>
                        </ul>
                    </div>


                    <a class="logo_header_show navbar-brand flex-grow" href="#"
                       style="padding: 0 0 0 15px;float: left">
                        <img height="40px" class="logo-un"
                             style="float: left;margin-bottom: 10px;max-width: 190px;"
                             src="{{ asset('/images/full-logo-red.png') }}" alt="Logo"/>
                    </a>
                </div>
            </nav>

        </header>
    </div>
    <main class="main-container">

        <div>

            @yield('content')
        </div>
    </main>
  <footer class="footer">
    <div class="footer-content-wrapper">
        <br/>
        <div class="container-fluid">
            <div class="row">
                <!-- القسم الأول - الخريطة والشعارات -->
                <div class="col-lg-3 col-md-3 col-12 mb-3">
                    <div class="footer-section from_down">
                        <div class="d-flex justify-content-center">
                            <a href="#">
                                <img height="270px" style="margin-right: -25px;max-width: 125%;padding: 10px;display: block;" 
                                     src="{{ asset('/images/footer_map.png?v=1') }}" alt="Logo"/>
                            </a>
                        </div>
                        <!-- الشعارات مع الروابط الجديدة -->
                        <div class="d-flex justify-content-center mt-3">
    <a href="{{ route('qmc_certificates') }}">
        <img src="{{ asset('images/QMS.svg') }}" alt="QMS" style="height: 60px"/>
    </a>
    <a href="{{ route('iso_certificates') }}" style="margin-right: 10px">
        <img src="{{ asset('images/Iso.svg') }}" alt="ISO" style="height: 60px"/>
    </a>
</div>
                    </div>
                </div>

                <!-- القسم الثاني - الروابط السريعة -->
                <div class="col-lg-3 col-md-3 col-12 mb-3">
                    <div class="d-flex flex-column align-items-center footer-section from_down">
                        <div class="d-flex justify-content-center align-items-center">
                            <div>
                                <div class="unicom_footer_title">
                                    <h3><b style="font-size: 20px">روابط سريعة</b></h3>
                                </div>
                                <br/>
                                <div style="width: 100%">
                                    <ul style="display: grid;grid-template-columns: 1fr 1fr;gap: 20px; list-style: none; padding: 0;margin: 0;">
                                        <li><a href="/about-us" class="footer_link">عن الشركة</a></li>
                                        <li><a href="/unicom" class="footer_link">فروعنا</a></li>
                                        <li><a href="/unicom-rowad" class="footer_link">رواد يونيكوم</a></li>
                                        <li><a href="/jobs" class="footer_link">التوظيف</a></li>
                                        <li><a href="#" class="footer_link">استراتيجية يونيكوم</a></li>
                                        <li><a href="http://proserveme.com/" target="_blank" class="footer_link">إدارة المشروعات</a></li>
                                        <li><a href="#" class="footer_link">بروفايل</a></li>
                                        <li><a href="/privacy" class="footer_link">سياسة الخصوصية</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- القسم الثالث - معلومات الاتصال -->
                <div class="col-lg-3 col-md-3 col-12 mb-3">
                    <div class="d-flex flex-column align-items-center footer-section from_down contact-info">
                        <div class="d-flex justify-content-center align-items-center">
                            <div>
                                <div class="unicom_footer_title">
                                    <h3><b style="font-size: 20px">معلومات الاتصال</b></h3>
                                </div>
                                <br/>
                                <div style="width: 100%">
                                    <ul style="display: grid;grid-template-columns: 1fr;gap: 20px; list-style: none;padding: 0;margin: 0;">
                                        <li>
                                            <div class="d-flex justify-content-start">
                                                <div>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="17" viewBox="0 0 12 17">
                                                        <path id="Icon_material-location-on" data-name="Icon material-location-on" d="M13.5,3a5.971,5.971,0,0,0-6,5.95c0,4.462,6,11.05,6,11.05s6-6.587,6-11.05A5.971,5.971,0,0,0,13.5,3Zm0,8.075A2.125,2.125,0,1,1,15.643,8.95,2.135,2.135,0,0,1,13.5,11.075Z" transform="translate(-7.5 -3)" fill="#fafafa"/>
                                                    </svg>
                                                </div>
                                                <div>
                                                    <a href="/unicom-saudi" style="color:#acb0b2;" class="footer_link">الرياض، المملكة العربية السعودية</a>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex justify-content-start">
                                                <div style="margin-top: 7px">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="15.667" height="16" viewBox="0 0 15.667 16">
                                                        <path id="Icon_awesome-phone-alt" data-name="Icon awesome-phone-alt" d="M15.22,11.307l-3.427-1.5a.724.724,0,0,0-.857.216L9.418,11.916A11.466,11.466,0,0,1,4,6.379l1.854-1.55a.759.759,0,0,0,.211-.875L4.593.454A.735.735,0,0,0,3.751.019L.569.769A.747.747,0,0,0,0,1.5,14.35,14.35,0,0,0,14.2,16a.738.738,0,0,0,.716-.581l.734-3.25a.763.763,0,0,0-.429-.863Z" fill="#fafafa"/>
                                                    </svg>
                                                </div>
                                                <div>
                                                    <a href="#" style="color: #acb0b2; unicode-bidi: embed; direction: ltr; text-align: right; display: inline-block;" class="footer_link">+2 254-784-9874</a>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex justify-content-start">
                                                <div>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="15.667" height="10.533" viewBox="0 0 15.667 12.533">
                                                        <path id="Icon_material-email" data-name="Icon material-email" d="M17.1,6H4.567A1.565,1.565,0,0,0,3.008,7.567L3,16.967a1.571,1.571,0,0,0,1.567,1.567H17.1a1.571,1.571,0,0,0,1.567-1.567v-9.4A1.571,1.571,0,0,0,17.1,6Zm0,3.133L10.833,13.05,4.567,9.133V7.567l6.267,3.917L17.1,7.567Z" transform="translate(-3 -6)" fill="#fafafa"/>
                                                    </svg>
                                                </div>
                                                <div>
                                                    <a href="mailto:info@unicomg.com" style="color: #acb0b2" class="footer_link">info@unicomg.com</a>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- القسم الرابع - الشعار ونموذج الاشتراك -->
                <div class="col-lg-3 col-md-3 col-12 mb-3">
                    <div class="footer-section from_down" style="margin-top: -20px">
                        <div>
                            <a href="#">
                                <img style="width: 230px;padding: 10px; display: block;margin: auto" 
                                     src="{{ asset('/images/logo.png') }}" alt="Logo"/>
                            </a>
                        </div>
                        <br/>
                        <div class="d-flex justify-content-center align-item-center">
                            <div>
                                <p style="font-size: 14px;max-width: 250px">اشترك في نشرتنا الإخبارية للحصول على آخر التحديثات والأخبار</p>
                                <form action="{{ route('mail-subscrib.store') }}" method="post">
                                    @csrf
                                    <table>
                                        <tr>
                                            <td>
                                                <div style="height: 100%">
                                                    <input type="text" 
                                                           class="email-placehoder" 
                                                           style="border: none;font-size: 16px;color: #0B2F58;height: 48px;margin-top: 7px;border-radius: 4px;caret-color: #0B2F58;max-height: 100px;width: 200px;" 
                                                           name="email" 
                                                           placeholder="اكتب بريدك الإلكتروني هنا">
                                                </div>
                                            </td>
                                            <td>
                                                <button class="btn btn2" style="width: 100%;height: 48px;margin:24px 0 0 5px;padding: 10px;">اشتراك</button>
                                            </td>
                                        </tr>
                                    </table>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div>
                            <a href="#" style="text-align: center; display: block;margin: auto">
                                <img src="/svg/logo2030.svg"/>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>


    <div style="background-color: #40465C;width: 100%;height: 50px" class="d-flex justify-content-center">
        <div class="copyright" style="float: right;padding: 16px;color: white">© 2025 Copyrights unicom</div>
    </div>

{{--    <script>--}}
{{--        window.addEventListener('scroll', function () {--}}
{{--            var header = document.getElementById('header');--}}
{{--            if (window.scrollY > 0) {--}}

{{--                $('.dropdown-content').removeClass('block');--}}
{{--                $('.dropdown').removeClass('dropdown-target');--}}
{{--            } else {--}}
{{--            }--}}
{{--        });--}}
{{--    </script>--}}

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"
            integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.12.5/dist/gsap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.12.5/dist/ScrollTrigger.min.js"></script>


    <script>
        const text_home = "إمكانيات لا حدود لها في جميع أنحاء العالم!";
        const container_home = document.getElementById("typing_characters");


        function animateIn(element) {
            gsap.to(element, {
                opacity: 1,
                x: 0,
                y: 0,
                display: 'block',
                duration: 2,
                ease: "power2.out",
                overwrite: "auto"
            });
        }


        function animateOutRight(element) {
            gsap.to(element, {
                opacity: 0,
                x: 100,

                duration: 1,
                ease: "power2.in",
                overwrite: "auto"
            });
        }

        function animateOutRightUp(element) {
            gsap.to(element, {
                opacity: 0,
                x: 100,
                y: -100,
                duration: 1,
                ease: "power2.in",
                overwrite: "auto"
            });
        }

        function animateOutLeft(element) {
            gsap.to(element, {
                opacity: 0,
                x: -100,
                duration: 1,
                ease: "power2.in",
                overwrite: "auto"
            });
        }

        function animateOutLeftDown(element) {
            gsap.to(element, {
                opacity: 0,
                x: -100,
                y: 100,
                duration: 1,
                ease: "power2.in",
                overwrite: "auto"
            });
        }

        function animateOutDown(element) {
            gsap.to(element, {
                opacity: 0,
                y: 100,
                duration: 1,
                ease: "power2.in",
                overwrite: "auto"
            });
        }


        function setupTypingAnimation() {
            // Clear previous content
            if (container_home) {
                container_home.innerHTML = '';

                // Create spans for each character
                text_home.split("").forEach(char => {
                    const span = document.createElement("span");
                    span.textContent = char;
                    span.style.opacity = 0;
                    container_home.appendChild(span);
                });

                const dot_1 = document.createElement("span");
                const dot_2 = document.createElement("span");
                const dot_3 = document.createElement("span");
                dot_1.innerHTML = "<span style='opacity: 1;margin-right: 10px'>.</span>";
                dot_2.innerHTML = "<span style='opacity: 0.5'>.</span>";
                dot_3.innerHTML = "<span style='opacity: 0.2'>.</span>";
                dot_1.style.color = "#fff";
                dot_2.style.color = "#fff";
                dot_3.style.color = "#fff";
                dot_1.style.fontWeight = "bold";
                dot_2.style.fontWeight = "bold";
                dot_3.style.fontWeight = "bold";
                dot_1.style.fontSize = "30px";
                dot_2.style.fontSize = "30px";
                dot_3.style.fontSize = "30px";

                container_home.appendChild(dot_1);
                container_home.appendChild(dot_2);
                container_home.appendChild(dot_3);
            }


        }

        function animateTyping() {
            gsap.to("#typing_characters > span", {
                opacity: 1,
                duration: 0.05,
                stagger: 0.05,
                ease: "none"
            });

        }

        function resetTyping() {
            gsap.set("#typing_characters > span", {
                opacity: 0
            });
            // gsap.set('#dots', {opacity: 0});
        }


        function start_gsap_animation() {
            circle = document.querySelector('.logo_circle');
            if (circle) {
                circle.addEventListener('mouseenter', () => {
                    gsap.to(circle, {
                        duration: 0.3,
                        scale: 1.5,
                        ease: "power2.out"
                    });
                });

                circle.addEventListener('mouseleave', () => {
                    gsap.to(circle, {
                        duration: 0.3,
                        scale: 1,
                        ease: "power2.in"
                    });
                });
            }


            gsap.to(".logo_circle", {
                duration: 2, // Duration of the animation
                boxShadow: "0 0 20px rgba(0, 0, 0, 1)", // Shadow with opacity 1
                // ease: "power2.inOut", // Ease function for smooth animation
                ease: "linear", // Ease function for smooth animation
                repeat: -1, // Infinite loop
                yoyo: true, //
            });


            setupTypingAnimation();
            ScrollTrigger.create({
                trigger: "#typing_characters",
                // start: "top bottom-=0",
                // end: "bottom top+=0",
                onEnter: () => {
                    resetTyping();
                    animateTyping();
                },
                onEnterBack: () => {
                    resetTyping();
                    animateTyping();
                },
                onLeave: resetTyping,
                onLeaveBack: resetTyping,
                toggleActions: "play none none none",
                // markers: true // For debugging, remove in production
            });
            gsap.to('.waveImage', {
                y: -30,
                duration: 2.5,
                ease: "sine.inOut",
                repeat: -1,
                yoyo: true
            });
            gsap.utils.toArray('.from_right').forEach((element) => {
                gsap.set(element, {
                    opacity: 0,
                    x: 100
                }); // Set initial state
                ScrollTrigger.create({
                    trigger: element,
                    start: "top bottom-=50",
                    end: "bottom top-=50",
                    onEnter: () => animateIn(element),
                    onEnterBack: () => animateIn(element),
                    onLeave: () => animateOutRight(element),
                    onLeaveBack: () => animateOutRight(element),
                    toggleActions: "play none none none",
                });
            });
            gsap.utils.toArray('.from_up_right').forEach((element) => {
                gsap.set(element, {
                    opacity: 0,
                    x: 100,
                    y: -100
                }); // Set initial state
                ScrollTrigger.create({
                    trigger: element,
                    start: "top bottom-=50",
                    end: "bottom top-=50",
                    onEnter: () => animateIn(element),
                    onEnterBack: () => animateIn(element),
                    onLeave: () => animateOutRightUp(element),
                    onLeaveBack: () => animateOutRightUp(element),
                    toggleActions: "play none none none",
                });
            });
            gsap.utils.toArray('.from_down_left').forEach((element) => {
                gsap.set(element, {
                    opacity: 1,
                    x: -100,
                    y: 100
                }); // Set initial state
                ScrollTrigger.create({
                    trigger: element,
                    start: "top bottom-=50",
                    end: "bottom top-=50",
                    onEnter: () => animateIn(element),
                    onEnterBack: () => animateIn(element),
                    onLeave: () => animateOutLeftDown(element),
                    onLeaveBack: () => animateOutLeftDown(element),
                });

            });
            gsap.utils.toArray('.from_left').forEach((element) => {
                gsap.set(element, {
                    opacity: 1,
                    x: -100
                }); // Set initial state
                ScrollTrigger.create({
                    trigger: element,
                    start: "top bottom-=50",
                    end: "bottom top-=150",
                    onEnter: () => animateIn(element),
                    onEnterBack: () => animateIn(element),
                    onLeave: () => animateOutLeft(element),
                    onLeaveBack: () => animateOutLeft(element),
                });

            });
            gsap.utils.toArray('.from_down').forEach((element) => {
                gsap.set(element, {
                    opacity: 0,
                    y: 100
                }); // Set initial state
                ScrollTrigger.create({
                    trigger: element,
                    start: "top bottom-=50",
                    end: "bottom top-=50",
                    onEnter: () => animateIn(element),
                    onEnterBack: () => animateIn(element),
                    onLeave: () => animateOutDown(element),
                    onLeaveBack: () => animateOutDown(element),
                });

            });


            gsap.to('.logo_circle', {
                duration: 4,
                rotation: -360,
                repeat: -1,
                ease: "linear",

                transformOrigin: "center center"
            });
            gsap.to('.logo_circle_only', {
                duration: 4,
                rotation: -360,
                repeat: -1,
                ease: 'none',

                transformOrigin: "center center"
            });
            gsap.to('.back_and_forward', {
                duration: 1.5,
                x: 20,
                repeat: -1,
                ease: "linear",
                yoyo: true
            });
            const button = document.querySelector(".wave-button");
            if (button) {
                button.addEventListener("mouseenter", () => {
                    gsap.to(button, {
                        backgroundColor: "#4de73c", // New background color on hover
                        duration: 0.5
                    });

                    gsap.fromTo(
                        button.querySelector("::before"), {
                            scale: 0
                        }, {
                            scale: 1,
                            duration: 0.5,
                            ease: "power1.out"
                        }
                    );
                });

                button.addEventListener("mouseleave", () => {
                    gsap.to(button, {
                        backgroundColor: "#3498db", // Reset to original color
                        duration: 0.5
                    });

                    gsap.to(button.querySelector("::before"), {
                        scale: 0,
                        duration: 0.5,
                        ease: "power1.in"
                    });
                });

            }


            const button22 = document.querySelector('.slider-button');

            if (button22) {
                const sliderTimeline = gsap.timeline({
                    paused: true
                });

                sliderTimeline.to(button22, {
                    "--slider-offset": "0%", // Custom property to animate the slide
                    duration: 0.4,
                    ease: "power2.out",
                });

                // Play the animation on hover
                button22.addEventListener("mouseenter", () => {
                    sliderTimeline.play();
                });

                // Reverse the animation on mouse leave
                button22.addEventListener("mouseleave", () => {
                    sliderTimeline.reverse();
                });

            }

        }


        $(document).ready(function () {

            // console.log('jquery scroll')
        });

        // window.addEventListener('load', () => {
        //     // $(this).scrollTop(0, 0);
        //
        //     setTimeout(() => {
        //         ScrollTrigger.refresh();
        //     }, 500);
        //
        //     if (window.scrollY > 0) {
        //         $(this).scrollTop(0, 0);
        //         window.onbeforeunload = function () {
        //             window.scrollTo(0, 0);
        //         }
        //         // Manually trigger animations or update scroll positions
        //         ScrollTrigger.update();
        //     }
        // });

        // document.addEventListener("DOMContentLoaded", function (event) {
        //
        //
        //     window.onbeforeunload = function () {
        //         window.scrollTo(0, 0);
        //     }
        //
        //
        //     setTimeout(function () {
        //         // start_gsap_animation();
        //     }, 1000)
        //
        //
        // });
    </script>

    <script>
        var dropdowntimeout = null;
        $(document).ready(function () {
            // disable hover on large then lg
            // if ($(window).width() > 992) {
            $(".dropdown").hover(
                function () {
                    $('.dropdown-menu', this).not('.in .dropdown-menu').stop(true, true).slideDown(10);
                    $(this).addClass('open');
                },
                function () {
                    $('.dropdown-menu', this).not('.in .dropdown-menu').stop(true, true).slideUp(10);
                    $(this).removeClass('open');
                }
            );
            // }

        });


        {{--function getunciomSudiea() {--}}
        {{--    window.location.href = "{{ route('unicom_saudi') }}";--}}
        {{--}--}}

        function goto(link) {
            window.location.href = link;
        }

        function goto_new_tab(link) {
            window.open(
                link,
                '_blank' // <- This is what makes it open in a new window.
            );
        }


    </script>
@yield('foot')
</body>

</html>
