@extends('layouts.home_layout')

@section('title', 'طلب نظام يونيكوم')

@section('head')

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/css/intlTelInput.css" />

    <style>
        .iti {
            width: 100%;
            direction: ltr;
        }
        .iti__flag {
            background-image: url("https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/img/flags.png");
        }
        @media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
            .iti__flag {
                background-image: url("https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/img/flags@2x.png");
            }
        }
        .form-container {
            max-width: 500px;
            margin: 2rem auto;
            padding: 1rem;
        }
        .invalid-feedback {
            display: none;
        }

        /* Force flag to left side in RTL */
        .iti--allow-dropdown .iti__flag-container,
        .iti--separate-dial-code .iti__flag-container {
            right: auto !important;
            left: 0 !important;
        }

        .iti--allow-dropdown input,
        .iti--allow-dropdown input[type=tel],
        .iti--separate-dial-code input,
        .iti--separate-dial-code input[type=tel] {
            padding-right: 6px !important;
            padding-left: 90px !important;
            margin-left: 0;
            direction: ltr;
            text-align: left;
        }

        .iti__country-list {
            left: 0 !important;
            right: auto !important;
        }

        .iti__selected-flag {
            border-radius: 0 3px 3px 0;
        }
    </style>

@endsection
@section('content')
    <section class="" style="background-color: #fafafa;">
        <div style="min-height: 40vh;margin-top: -36px; " class="d-flex justify-content-center align-items-center">
            <div
                style="margin: auto;text-align: center;margin: auto;text-align: center;font-size: 40px;font-weight: bold;">
                <img src="/images/unicom-Business.png" alt="unicom-business"/>
                <div class="" style="font-size: 16px;font-weight:normal;text-align: center;margin-top: -42px;"><span>الرئيسية /  </span><span
                        class="red-underline">طلب نظام</span></div>
            </div>
        </div>
    </section>

    <br/>
    <br/>

    <section>
        <div>
            <div class=""
                 style="background-color: var(--my-color-dark-grey);padding: 20px 20px;margin: 0 30px;border-radius: 6px">

                <div style="" class="row">
                    <div class="col-12 col-md-3 d-flex justify-content-center">
                        <img src="/images/2.png" alt="" style="margin-top: -150px;max-width: 300px;margin-bottom: -100px">
                    </div>
                    <div class="col-12 col-md-9 d-flex justify-content-center  align-items-center">

                        <div>
                            <div class="d-flex justify-content-center align-items-center">
                                <img src="/images/uincom logo.png" style="height: 60px;width: 60px ;" alt="">
                            </div>

                            <div class="d-flex justify-content-center align-items-center">
                                <div
                                    style="background-color: var(--my-color-dark-grey);padding: 10px;border-radius: 7px;width: fit-content">
                                    <div class="d-flex justify-content-center align-items-center">
                                        <div
                                            style="text-align: center;font-weight: 600;font-size: 31px;margin-top: 10px;color: #fff;">
                                            أحصل على النظام الان
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-center align-items-center">
                                        <div
                                            style="font-weight: normal;font-size: 18px;margin-top: 5px;text-align: center;color: #fff;">
                                            قم بتعبئة البيانات لتقديم طلب الحصول على النظام
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>

                <div class="d-flex justify-content-center align-items-center m-5" >

                    <div style="background-color: var(--my-color-grey2-bg);border-radius: 7px;padding: 20px">

                        <div class="row">

                            <div class="col-12 col-md-6">
                                <div class="mb-3">
                                    <label for="formGroupExampleInput" class="form-label" style="float: right">اسم الجهة </label>
                                    <input type="text" class="form-control" name="company_name" id="formGroupExampleInput">
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="mb-3">
                                    <label for="formGroupExampleInput" class="form-label" style="float: right">اسمك الكامل <span style="color: var(--my-color-red)">*</span></label>
                                    <input type="text" class="form-control" name="full_name" required id="formGroupExampleInput">
                                </div>
                            </div>

                            <div class="col-12 col-md-6">
                                <div class="mb-3">
                                    <label for="phone" class="form-label" style="float: right">رقم الهاتف <span style="color: var(--my-color-red)">*</span></label>
                                    <input type="tel" class="form-control" id="phone" name="phone" required>
                                    <div class="invalid-feedback">Please enter a valid phone number.</div>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="mb-3">
                                    <label for="phone" class="form-label" style="float: right">البريد الاكتروني <span style="color: var(--my-color-red)">*</span></label>
                                    <input type="text" class="form-control" id="phone" name="email" required>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="phone" class="form-label" style="float: right">حدد النظام</label>
                                    <select {{ request('system')!=null ? 'disabled': ''}}  class="form-select" aria-label="">
                                        <option hidden></option>
                                        <option {{ request('system') == '1' ? 'selected' : '' }}  value="1">نظام تخطيط موارد المؤسسات</option>
                                        <option {{ request('system') == '2' ? 'selected' : '' }} value="2">نظام أدارة المستندات UDOCS</option>
                                        <option {{ request('system') == '3' ? 'selected' : '' }}  value="3">تطوير أنظمة المؤسسات البريدية</option>
                                    </select>
                                </div>
                                <br>
                                <div style="text-align: right;padding: 10px 1px;">
                                    <button style="background-color: #b73138;border: none;padding: 10px 50px;border-radius: 4px;margin-right: 0px;"><a href="" style="text-decoration: none;color: #fff;">تقديم الطلب</a></button>
                                </div>
                            </div>


                        </div>


                    </div>
                </div>


            </div>

        </div>
    </section>

    <br>
    <br>
    <br>
    <br>
    <br>
    <br>
    <br>

@endsection
@section('foot')
    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/intlTelInput.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const phoneInput = document.querySelector("#phone");
            const phoneForm = document.querySelector("#phoneForm");
            const iti = window.intlTelInput(phoneInput, {
                utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.2.1/build/js/utils.js",
                separateDialCode: true,
                initialCountry: "sa", // Set Saudi Arabia as default
                preferredCountries: ["sa"], // Put Saudi Arabia at the top of the list
                customContainer: "iti iti--force-ltr",
            });

            phoneForm.addEventListener('submit', function(e) {
                e.preventDefault();

                if (!iti.isValidNumber()) {
                    phoneInput.classList.add('is-invalid');
                    return;
                }

                phoneInput.classList.remove('is-invalid');
                const fullNumber = iti.getNumber();
                console.log('Valid phone number:', fullNumber);
            });

            phoneInput.addEventListener('input', function() {
                phoneInput.classList.remove('is-invalid');
            });
        });
    </script>
@endsection

