@extends('layouts.home_layout')

@section('title', 'يونيكوم الخليج')

@section('head')

    <style>
        .scroll-container {
            /*position: relative;*/
            width: 100%;
            height: 200px;
            background: transparent;
            margin: 20px 0;
        }

        .scroll-content {
            /*position: absolute;*/
            display: flex;
        }

        .scroll-content.ltr {
            left: -100%;
            animation: scrollLeftToRight 50000s linear infinite;
        }

        .scroll-content.rtl {
            animation: scrollRightToLeft 30s linear infinite;
        }

        .scroll-item {
            margin: 5px 50px;
        }

        @keyframes scrollLeftToRight {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(100%);
            }
        }

        @keyframes scrollRightToLeft {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-100%);
            }
        }

        .scroll-container:hover .scroll-content {
            animation-play-state: paused;
        }

        .img_size {
            width: 100px;
            height: 100px;
        }
    </style>

@endsection
@section('content')
    <section class="" style="background-color: #fafafa;">
        <div style="min-height:60vh;    margin-top: -36px; " class="d-flex justify-content-center align-items-center">
            <div
                style="color: var(--my-color-dark-grey);margin: auto;text-align: center;font-size: 35px;font-weight: bold;">
                <img style="max-width: 300px" src="/images/logo/gulf.png" alt="unicom_telecom"/>
                <div class="" style="font-size: 16px;font-weight:normal;text-align: center;margin-top: -42px;">
                    <span>الرئيسية / </span><span class="red-underline"> يونيكوم الخليج</span>
                </div>

            </div>
        </div>
    </section>


    <section style="background-image: linear-gradient(#e9ecef, #fff);">

        <div class="row">
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 d-flex justify-content-center">
                <img src="/gulf/jumira.png" alt=""
                     style="    margin-top: -100px;margin-right: -80px;max-width: 300px;">
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-8 d-flex justify-content-center">
                <div class="text-content">
                    <h1 class="text-content-h1">يونيكوم الخليج</h1>
                    <p class="text-content-p">هي إحدى شركات المجموعة المتخصصة في الحلول التقنية لتنفيذ إدارة استراتيجية
                        و المستدامة للعملاء خارج المجموعة مع العمل على تطوير ونمو هذه القطاعات من خلال حلول متخصصة
                        مدعومة بتحليل السوق الدولي المحلي و العالمي.
                    </p>
                    <br>
                    <br>
                    <p class="text-content-p">نسعى إلى تحسين استراتيجيات الاستثمار من خلال استثماراتنا التي تتمحور إلى
                        تعزيز فرص ومشاريع مستدامة في الأسواق المستهدفة من خلال تقديم المشاريع والحلول التقنية مع الهدف
                        لزيادة الإيرادات بنظام (BOT) للبناء والتشغيل والتحويل بالشراكة مع القطاع العام و الخاص وتقديم
                        الدعم الفني المستمر بما يضمن نجاح المشروعات</p>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div
            style="padding: 0 30px;font-weight: bold;font-size: 22px;line-height: 62px;text-align: center;color: var(--my-color-blue-text);">
            <span>عملاءنا بالقطاع</span>
            <span class="red-underline">الخاص</span>

        </div>
        <br />

        <div class="d-flex flex-wrap justify-content-center" style="padding: 0 50px">
            <div style="background-color: #fafafa;border-radius: 10px;margin: 10px">
                <img src="/gulf/c2.png" alt="Logo 1"
                     class="card-grid-item">
            </div>
        </div>
{{--        <div class=" mb-4">--}}
{{--            <div class=" p-0">--}}
{{--                <div class="scroll-container">--}}
{{--                    <div class="scroll-content ltr" id="ltrContent">--}}
{{--                        <div class="scroll-item "><img src="/gulf/c1.png" alt="Logo 1" style="height: 120px;width: 120px"></div>--}}
{{--                        <div class="scroll-item "><img src="/gulf/c2.png" alt="Logo 1" style="height: 120px;width: 120px"></div>--}}

{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}

    </section>




    <br>
    <br>
    <br>
    <br>

@endsection
@section('foot')

    <script></script>

    <script>
        function setContentWidth(element) {
            const items = element.children;
            const itemWidth = items[0].offsetWidth;
            const totalWidth = itemWidth * (items.length / 2);
            element.style.width = `${totalWidth * 2}px`;
        }

        // Initialize both scroll containers
        window.addEventListener('load', () => {
            const ltrContent = document.getElementById('ltrContent');
            const rtlContent = document.getElementById('rtlContent');
            setContentWidth(ltrContent);
            setContentWidth(rtlContent);
        });

        // Handle resize for both containers
        window.addEventListener('resize', () => {
            const ltrContent = document.getElementById('ltrContent');
            const rtlContent = document.getElementById('rtlContent');
            setContentWidth(ltrContent);
            setContentWidth(rtlContent);
        });
    </script>
@endsection
