<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/our-work', [App\Http\Controllers\HomeController::class, 'our_work'])->name('our_work.home');
Route::get('/unicom-solutions', [App\Http\Controllers\HomeController::class, 'unicom_solutions'])->name('unicom_solutions');
Route::get('/unicom-rowad', [App\Http\Controllers\HomeController::class, 'unicom_rowad'])->name('unicom_rowad');
Route::get('/about-us', [App\Http\Controllers\HomeController::class, 'bout_us'])->name('bout_us');
Route::get('/counties/saudi-arabia', [App\Http\Controllers\HomeController::class, 'unicom_saudi'])->name('country.unicom_saudi');


Route::get('/counties/gulf', [App\Http\Controllers\HomeController::class, 'gulf'])->name('country.gulf');

Route::get('/counties/egypt', [App\Http\Controllers\HomeController::class, 'egypt'])->name('country.egypt');

Route::get('/counties/yemen', [App\Http\Controllers\HomeController::class, 'yemen'])->name('country.yemen');

Route::get('/counties/sudan', [App\Http\Controllers\HomeController::class, 'sudan'])->name('country.sudan');
Route::get('/counties/china', [App\Http\Controllers\HomeController::class, 'china'])->name('country.china');

//Route::get('/counties/saudi-Arabia',[App\Http\Controllers\HomeController::class, 'unicom_saudi'])->name('unicom_saudi');
Route::get('/initiatives', [\App\Http\Controllers\HomeController::class, 'initiatives'])->name('initiatives');
Route::get('/contact-us', [App\Http\Controllers\HomeController::class, 'contact_us'])->name('contact_us');
Route::get('/projects-managements', [App\Http\Controllers\HomeController::class, 'projects_managements'])->name('projects_managements');
Route::get('/news', [App\Http\Controllers\HomeController::class, 'news'])->name('news');
Route::get('/telecom', [App\Http\Controllers\HomeController::class, 'telecom'])->name('telecom');
Route::get('/unicom-companies', [App\Http\Controllers\HomeController::class, 'unicom_companies'])->name('unicom_companies');
Route::get('/unicom', [App\Http\Controllers\HomeController::class, 'unicom'])->name('unicom');

Route::get('/test', [App\Http\Controllers\HomeController::class, 'test'])->name('test');
Route::get('/test2', [App\Http\Controllers\HomeController::class, 'test2'])->name('test2');

Route::get('/systems/org-resources', [\App\Http\Controllers\SystemsPagesController::class, 'org_resources'])->name('our_work.org_resources');
Route::get('/systems/org-postal', [\App\Http\Controllers\SystemsPagesController::class, 'org_postal'])->name('our_work.org_postal');
Route::get('/systems/documents-management', [\App\Http\Controllers\SystemsPagesController::class, 'document_management'])->name('our_work.document_management');

Route::get('/jobs', [App\Http\Controllers\HomeController::class, 'jobs'])->name('jobs');
Route::get('/jobs/{id}', [App\Http\Controllers\HomeController::class, 'job_details'])->name('jobsDetails');
Route::get('request-system', [\App\Http\Controllers\HomeController::class, 'request_system'])->name('our_work.request_system');
Route::post('/mail-subscribe', [App\Http\Controllers\MailSubscribeController::class, 'store'])->name('mail-subscrib.store');
Route::get('/privacy',[\App\Http\Controllers\HomeController::class,'privacy'])->name('privacy');

Route::prefix('/solutions')->group(function () {
    Route::get('/fleet', [\App\Http\Controllers\SolutionsController::class, 'fleet'])->name('fleet');
    Route::get('/justice', [\App\Http\Controllers\SolutionsController::class, 'justice'])->name('justice');
    Route::get('/local', [\App\Http\Controllers\SolutionsController::class, 'local'])->name('local');
    Route::get('/hospital', [\App\Http\Controllers\SolutionsController::class, 'hospital'])->name('hospital');
    Route::get('/electric', [\App\Http\Controllers\SolutionsController::class, 'electric'])->name('electric');
});


Route::get('/iso-certificates', [\App\Http\Controllers\HomeController::class, 'iso_certificates'])->name('iso_certificates');
Route::get('/qmc-certificates', [\App\Http\Controllers\HomeController::class, 'qmc_certificates'])->name('qmc_certificates');