import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js'],
            refresh: [
                'resources/views/**', // Watch Blade files for changes
                'routes/**',          // Optional: Watch route files
            ],
            // refresh: true,
        }),
    ],
    server: {
        watch: {
            usePolling: true, // Useful for file systems that require polling
        },
    },
});
